package gov.va.genisis2.converter;

import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.UserCountDTO;
import gov.va.genisis2.exceptions.ErrorEnum;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.UserCount;

/**
 * This class is used to convert UserCountDTO to UserCount entity and
 * vice-versa.
 * 
 * @author PII
 *
 */
@Component
public class UserCountConverter {

	private static final Logger LOGGER = LoggerFactory.getLogger(UserCountConverter.class);

	public UserCountDTO populateUserCount(List<UserCount> userCounts, Date lastRefreshed) throws GenisisServiceException {
		UserCountDTO userCountDto = new UserCountDTO();

		userCountDto.setLastRefreshed(lastRefreshed);
		userCountDto.setDispLastRefreshed(lastRefreshed);
		
		if (null != userCounts && !userCounts.isEmpty()) {
			userCountDto.setTotalUsers(0);
			for (UserCount userCount : userCounts) {
				switch (userCount.getRoleTypeId()) {
				case 1: 
					getAdminCount(userCount, userCountDto);
					break;
				case 2: 
					getRequestersCount(userCount, userCountDto);
					break;
				case 3:
					getDDMsCount(userCount, userCountDto);
					break;
				case 4:
					getDSMsCount(userCount, userCountDto);
					break;
				default:
					LOGGER.error(ErrorEnum.INVALID_ROLETYPEID.getErrorMessage() + userCount.getRoleTypeId());
					throw new GenisisServiceException(ErrorEnum.INVALID_ROLETYPEID.getErrorMessage() + userCount.getRoleTypeId());
				}
			}
		}

		return userCountDto;
	}

	private void getAdminCount(UserCount userCount, UserCountDTO userCountDto) {
		userCountDto.setNumAdmins(userCount.getCount());
	}
	
	private void getRequestersCount(UserCount userCount, UserCountDTO userCountDto) {
		userCountDto.setNumRequesters(userCount.getCount());
		userCountDto.setTotalUsers(userCountDto.getTotalUsers() + userCount.getCount());
	}
	
	private void getDDMsCount(UserCount userCount, UserCountDTO userCountDto) {
		userCountDto.setNumDDMs(userCount.getCount());
		userCountDto.setTotalUsers(userCountDto.getTotalUsers() + userCount.getCount());
	}
	
	private void getDSMsCount(UserCount userCount, UserCountDTO userCountDto) {
		userCountDto.setNumDSMs(userCount.getCount());
		userCountDto.setTotalUsers(userCountDto.getTotalUsers() + userCount.getCount());
	}
}
